;;;   v_setvar.lsp v2.0
;;;   Preset Values and defaults for VCad-2.0 routines.

;;;   Typical line --> VARIABLE NAME (min 1 space) VALUE. VALUE should be
;;;   edited or verified by user. 

;;;   Or--lines may be elements of a variable "list" and may be changed.
;;;   
;;;   Blank "string" entries are entered w/ dbl quotes ("")
;;;   Do not change format, e.g. quated strings, decimal numbers, etc.
;;;   Decimal numbers less than 1 MUST begin with zero (e.g. 0.123)
;;;   Inactive code or "comments" follow semi-colon(s)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun v_set1 () (setq  ;;         no edit    ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** FILES/PATHS **************************************
;; Use full path name with DOUBLE BACKSLASHES (\\)

;;-----------Directory path name where VCad dwg blocks are stored:
gp82 "c:\\acad\\vdwg\\" 

;;-----------Line type file used (e.g. "c:\\acad\\support\\acad.lin")
gp10 "c:\\r13\\com\\support\\acad.lin"

;;-----------Default directory to store dim style definition files. 
gp83 "c:\\acad\\dim\\"

;;******************* LAYER GROUPS--SOFTDESK ***************************
g_lck   "f"        ;; Check for and optionally use active Softdesk layer group
                   ;; name componets.  ("t"=true  "f"=false)
;;******************* LAYER GROUPS--ALL ********************************
g_pla   "f"        ;; Plan componet used in layer group names? (t/f or ""=N/A
;;******************* LAYER GROUPS--NON-SOFTDESK (See docs) ************
g_lypat ""         ;; Layer group name template--use only if Softdesk is
                   ;; NOT installed  e.g. "{T}{P}{R}{L}{M}" (see Doc). ""=N/A
g_spp   ""         ;; Layer group name separator--use only if SDSK NOT installed
                   ;; (e.g. "_").  Use "" if N/A,
;;******************* SOFTDESK ALTERNATE MACROS ************************
g_sdsk  "f"        ;; Load alternate Softdesk macros--v_sdsk.lsp? (t/f or ""=N/A)

;; ****************** CUSTOM STATUS LINE *******************************
g_mdf   ""         ;; Name of modemacro file to load (w/ no file extension)
                   ;; Options provided: "V_mDOS"--DOS; "V_mDOSs"--Shorter length;
                   ;; "V_mWIN"--R13+ Windows;  ""--none

;; ****************** LINE DRAW D Series (also used in some objects) ***
gl1  "xfine"       ;; Layer, X-thin line
gc1  5             ;; Color, layer #1 
gl2  "thin"        ;; Layer, thin line 
gc2  3             ;; Color, layer #2
gl3  "medium"      ;; Layer, medium line
gc3  1             ;; Color, layer #3
gl4  "heavy"       ;; Layer, heavy line
gc4  7             ;; Color, layer #4

;; ****************** DASHED LINE TYPES, LINE DRAW D-series ************
gl10 "hidden"      ;; Layer, dashed xfine line
gc10 5             ;; Color, layer #10
gy10 "dashed"      ;; Linetype name, #10  (alternate= "dash32" IF DEFINED)
 
gl11 "dashed"      ;; Layer, dashed thin line
gc11 3             ;; Color, layer #11
gy11 "dashed2"     ;; linetype name, #11  (alt= "dash16") 

gl12 "mdash"       ;; Layer, dashed med line
gc12 1             ;; Color, layer #12
gy12 "dashedx2"    ;; Linetype name, #12  (alt= "dash332")

gl13 "hdash"       ;; Layer, dashed heavy line
gc13 7             ;; Color layer #13
gy13 "dashedx2"    ;; linetype name, #13  (alt= "dashed2")

;; ****************** DOT LINE TYPES, LINE DRAW D-SERIES ***************
gl14 "phantom"     ;; Layer, dotted xfine line
gc14 11            ;; Color, layer #14
gy14 "dot"         ;; Linetype name, #14  (alternate= "dot4" IF DEFINED)

gl15 "dot"         ;; Layer, dotted thin line 
gc15 2             ;; Color, layer #15
gy15 "dot"         ;; Linetype name, #15  (alt= "dot2")
                
gl16 "mdot"        ;; Layer, dotted med line
gc16 1             ;; Color layer #16
gy16 "dot2"        ;; Linetype name #16   (alt= "dot332")

gl17 "hdot"        ;; Layer dotted heavy line
gc17 7             ;; Color, layer #17
gy17 "dotx2"       ;; Linetype name #17   (alt= "dot")

;; ****************** NOTE TEXT ****************************************
gl20 "anntext"     ;; Layer, typical note/anotation/leader text
gc20 4             ;; Color, layer #20
gt20 "anntext"     ;; Style, for #20
gh20 0.09375       ;; Plot height (inches), for #20 (e.g .09375=3/32")
gs20 "anntxts"     ;; Layer, Small size annot text
gk20 5             ;; Color, Small size annot text
gz20 0.0625        ;; Plot height (inches), small size annot text

;; ****************** ANNOTATION OBJECTS *******************************
gl30  "annobj"     ;; Layer, leader lines, etc
gc30  4            ;; Color, layer #30

;; ****************** PLAN VIEW ****************************************
gx80 34.5          ;; Width, plot size of "sheet" for Plan View (inches)
gx81 23.0          ;; Height, plot size of sheet for Plan View 
go80  0.5          ;; Plot unit X-Offset from origin (lower left corner)
go81 -1.0          ;; Plot unit Y-Offset form origin (lower left corner)

;; ****************** TEXT UTILITY *************************************
gx85 1.0           ;; WORD WRAP--Text hyphen prompt: min plot length (in) 
                   ;; of trailing blank space in line, to prompt for hyphen.

;; ****************** MULTISCALE ***************************************
gldt "detborder"   ;; Layer name--to use w/ "auto-zoom" when the "check
                   ;; border layer only" option is being used.

;; ****************** DIMENSIONS ***************************************
gydim "center2"    ;; Lintype name for "centered" dimension extension lines
                   ;;                     (alt= "dimcen" if defined)
gd83  "v_dimdot"   ;; Dot arrow block for centered conditon dim's
gd84  "v_dimtck"   ;; Default arrow block for dim-mark-restore

;; ******************* XWRITE DDBOX ************************************
gdxx ""            ;; Dialog box assumes mono text for DOS and MS-proportional
                   ;; for Windows. Use "m" to use mono in Windows.
                   ;; Use "" to use default.

;; ****************** TEXT COMMANDS (T1-4 & TT1-4) *********************
gtxt (list  ;; no edit
;;  NOTE: Lines are elements of a "list".  Template as follows:
;; '(style_name  text_ht  layname  lay_color) --------------------------

;;---------------------------------------- T-SERIES TEXT 
'("txg1"      0.09375   "txg1"     4)   ;; T1  sml
'("txg2"      0.125     "txg2"     1)   ;; T2  med
'("txg3"      0.1875    "txg3"     7)   ;; T3  lrg
'("txg4"      0.25      "txg4"     7)   ;; T4  x-lrg

;;---------------------------------------- TT-SERIES TEXT (Font Family option)
                                        ;;          Style name= "H" if
; '("H"       0.125     "tt1"      5)   ;; TT1 sml  using font family 
; '("H"       0.1875    "tt2"      4)   ;; TT2 med  option, style name will
; '("H"       0.25      "tt3"      1)   ;; TT3 lg   be created at runtime.
; '("H"       0.5       "tt4"      7)   ;; TT4 xlg  (leading semi-colons
                                        ;;           set lines inactive)

;;---------------------------------------- TT-SERIES TEXT (non-family option)
                                        ;;          Use actual style names
'("TTX1"      0.125     "tt1"      5)   ;; TT1 sml  and define in v_fonts 
'("TTX2"      0.1875    "tt2"      4)   ;; TT2 med  file. (no leading semi-
'("TTX3"      0.25      "tt3"      1)   ;; TT3 lg   colons means these
'("TTX4"      0.5       "tt4"      7)   ;; TT4 xlg  lines are active)
                                        ;;          (see Doc)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
))(princ)) ;; end v_set1      No edit         ;
(defun v_set2 () (setq                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** AUX LINES DRAW  (F-SERIES) ***********************
g1l  "XTHN2"       ;; Layer x-thin       
g1c  200           ;; Color x-thin
g3l  "THIN2"       ;; Layer thin
g3c  125           ;; Col thin
g5l  "MED2"        ;; Layer med
g5c  232           ;; Col med
g7l  "HVY2"        ;; Layer heavy
g7c  253           ;; Col heavy

;; ****************** AUX LINES DRAW  (G-SERIES) ***********************
g2l  "XTHN3"       ;; Layer x-thin
g2c  223           ;; Col x-thin
g4l  "THIN3"       ;; Layer thin
g4c  120           ;; Col thin
g6l  "MED3"        ;; Layer med
g6c  30            ;; Col med
g8l  "HVY3"        ;; Layer heavy
g8c  41            ;; Col heavy 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)(princ)) ;; end v_set2       No edit         ;
(defun v_set3 () (setq                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** REFERENCE SYMBOLS (Detail & Section) *************
gh21  0.09375      ;; Plot height (inches), detail/section mark attrib text
ge31  0            ;; Default set--edit det/sec mark text @ insertion? (0/1)

gl31  "anndtobj"   ;; Layer, detail mark leader lines
gc31  4            ;; Color, layer #31
gx33  0.5625       ;; Diameter detail bubble mark (plot ht inches)

gl32  "annsxobj"   ;; Layer, section mark lines
gc32  4            ;; Color, layer #32
gx34  0.5625       ;; Diameter section bubble mark (.5625=9/16)

;; ****************** REFERENCE BUBBLE LEADER **************************
gl35  "anndtobj"   ;; Layer, bubble leader
gc35  4            ;; Color, layer #35
gt35  "anntext"    ;; Text Style for attribute
gh35   0.09375     ;; Text height for attribute

gxc35  0.375       ;; Diameter of circle bubble (plot dec. inches)
gxs35  0.375       ;; Height of square bubble
gxt35  0.375       ;; Height of triangle bubbleDiameter bubble
gxh35  0.375       ;; Height of hexagon bubble
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)(princ)) ;; end v_set3     No Edit           ;
(defun v_set4 () (setq                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** FRAMES & PANELS **********************************
gl74  "casework"   ;; Layer for casework description
gc74  3            ;; Color, layer 74
gl75  "windelev"   ;; Layer for window elevation description
gc75  2            ;; Color, layer 75
gl76  "doorelev"   ;; Layer for door elevation description
gc76  2            ;; Color, layer 76

gl77  "dswing"     ;; Elev Swing symbol layer
gc77  5            ;; Color, layer 77
gy77  "dashed2"    ;; Line type name, layer 77

gl78  "hatch"      ;; Layer for hatching
gc78  5            ;; Color, layer 78
gx78  "U"          ;; Hatch name ("U" up-case = user defined)
ga78  45.0         ;; Hatch angle (degrees)
gs78  0.0157       ;; Spacing (plot units) if User/ Scale if named
gd78  0            ;; Double hatch 0=no 1=yer (appl to user hatch only)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)(princ)) ;; end v_set4     No Edit           ;
(defun v_set5 () (setq                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** DRAWING TITLE ************************************
gl6  "titline"     ;; Layer, title underlines
gc6   7            ;; Color, layer #5
gx6   0.75         ;; Default extension length of title lines
gl25  "textl"      ;; Layer title bubble text
gc25  7            ;; Color layer #25
gh25  0.1875       ;; Plot Height of title bubble text (inches)
gx25  0.5          ;; Plot Diameter of title bubble

gl22  "textm"      ;; Layer Title text
gc22  1            ;; Color, layer #22
gt22  "titx1"      ;; Style-1, Title text
gh22  0.25         ;; Height, style 22-24
gt23  "titx2"      ;; Alt style-2, Title text
gt24  "titx3"      ;; Alt style-3, Title text

gl26  "textm"      ;; Layer Title subtext (e.g. "Scale=...)
gc26  1            ;; Color, layer #26
gt26  "tittextm"   ;; Style Title subtext
gh26  0.125        ;; Plot height Title subtext
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)(princ)) ;; end v_set5     No edit           ;
(defun v_set6 () (setq                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** STRUCTURAL OBJECTS *******************************
gl40  "structural" ;; Layer, frm members (w/ half arrows)
gc40  1            ;; Color, layer #40
gl41  "framing"    ;; Layer, beams (no arrows)
gc41  7            ;; Color, layer #41
gl42  "framext"    ;; Layer, extents (of frm members) w/dbl arrow 
gc42  3            ;; Color, layer #42
gl43  "consttag"   ;; Layer, construction tags/text
gc43  4            ;; Color, layer #43
gt43  "anntext"    ;; Style, construction annotation text
gh43  0.09375      ;; Plot height, for style #43 (decimal inches)
gl44  "jamb"       ;; Jamb layer for wall header routine
gc44  7            ;; Color, layer #44
                   ;; List of root layer names of object to erase if
gx45 (list         ;; (No edit this line)            found @ wall header
"OPENING"          ;; Begin list. Use upper case, insert lines as needed
"JAMB3D"           ;; For none enter "" at begin list line
"HEADER"           ;; Blank out other lines
"WALL3D"
)                  ;; end list (no edit this line)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)(princ)) ;; end v_set6     No edit           ;
(defun v_set7 () (setq                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ****************** WALL FILL HATCHING ROUTINE ***********************
gl70 "jambx"       ;; Layer for "temporary" lines
gc70  2            ;; Color, layer #70
gl71  "poche"      ;; Layer for wall fill hatch
gc71  9            ;; Color, layer #71
gl72  "jamb"       ;; Jamb layer 
gc72  7            ;; Color, layer #72
gl73  "wall"       ;; Layer of wall lines to hatch within
gc73  2            ;; Color layer #73
gx70  "U"          ;; HATCH   Name:  "U"=user or verified hatch name Up case.
gx71  0.0          ;;   Angle of hatch (both U or hatch name) degrees
gx72  0.0157       ;;   "User" spacing (plot units)-or-named hatch scale fac
gx73  1            ;;   Double? (1=yes 0=no).  Active for "user" hatch only
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)(princ)) ;; end v_set7     No edit           ;
;; end v_setvar.lsp                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



